unit [!UnitName];
// This file is a replacement for the Delphi for .NET "New WebControl"
// wizard found in the BDS\2.0\ObjRepos\DelphiDotNet directory.
// Make a backup of the existing file and replace the current file
// with this one to use it as your new template.

interface
{$REGION 'DB Web Options'}
/// <summary>
/// This web control wizard generates code that can be conditionally compiled to
/// add support for Borland's ASP.NET DB Web component architecture. The
/// following options are available:
///
/// Symbol      Purpose
/// =========== ========================
/// DBWEB       Provide design-time data and no-code connections to a DataSet,
///             DataView, or DataTable
/// DBWEBCOLUMN Add properties and methods to bind to a Data column. Requires
///             DBWEB to be defined.
/// DBWEBLOOKUP Add properties and methods to support lookup table value
///             references and corresponding assignment to a data column.
///             Requires DBWEBCOLUMN to be defined.
///
/// </summary>
{//$DEFINE DBWEB} // Remove "//" from "//$DEFINE" to enable DB Web framework
{//$DEFINE DBWEBCOLUMN} // Remove "//" from "//$DEFINE" to create a DB Web column control
{//$DEFINE DBWEBLOOKUP} // Remove "//" from "//$DEFINE" to create a DB Web lookup control
{$ENDREGION}

{$IFDEF DBWEB}
uses
  System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel, System.Collections.Specialized,
  System.Drawing.Design, Borland.Data.Web;
{$ELSE}
uses
  System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel;
{$ENDIF}


type
  /// <summary>
  /// Summary description for My[!CustomControlName].
  /// </summary>
  {$IFDEF DBWEB}
  {$REGION 'DB Web control declarations'}

  {$IF Defined(DBWEBLOOKUP)}
  // Use this declaration for controls that implement LookupTable values
	[Designer('Borland.Data.Web.DBWebControlDesigner'),
//   ToolboxBitmap(typeof(My[!CustomControlName]),
//   'My[!CustomControlName].bmp'),
	ToolboxData('<{0}:My[!CustomControlName] runat=server></{0}:My[!CustomControlName]>')]
  My[!CustomControlName] = class(System.Web.UI.WebControls.WebControl, IPostBackDataHandler, IDBWebLookupColumnLink)
  {$ELSEIF Defined(DBWEBCOLUMN) }
  // Use this declaration for controls that need ColumnName
	[Designer('Borland.Data.Web.DBWebControlDesigner'),
//   ToolboxBitmap(typeof(My[!CustomControlName]),
//   'My[!CustomControlName].bmp'),
	ToolboxData('<{0}:My[!CustomControlName] runat=server></{0}:My[!CustomControlName]>')]
  My[!CustomControlName] = class(System.Web.UI.WebControls.WebControl, IPostBackDataHandler, IDBWebColumnLink)
  {$ELSE}
  // Use this declaration for controls that only need DataSource and TableName
	[Designer('Borland.Data.Web.DBWebControlDesigner'),
//   ToolboxBitmap(typeof(My[!CustomControlName]),
//   'My[!CustomControlName].bmp'),
	ToolboxData('<{0}:My[!CustomControlName] runat=server></{0}:My[!CustomControlName]>')]
  My[!CustomControlName] = class(System.Web.UI.WebControls.WebControl, IPostBackDataHandler, IDBWebDataLink)
  {$IFEND}
  {$ENDREGION}
  {$ELSE}
  {$REGION 'ASP.NET WebControl descendant initialization'}
  // Use these attributes for standard ASP.NET controls
  [DefaultProperty('Text'),
//   ToolboxBitmap(typeof(My[!CustomControlName]),
//   'My[!CustomControlName].bmp'),
   ToolboxData('<{0}:My[!CustomControlName] runat=server></{0}:My[!CustomControlName]>')]
  My[!CustomControlName] = class(System.Web.UI.WebControls.WebControl)
  {$ENDIF}

  strict private
    FText: String;

  strict protected
    // Override Render when descending directly from ASP.NET Control
    // procedure Render(Output: HtmlTextWriter); override;

    // Override RenderContents when descending from ASP.NET WebControl
    procedure RenderContents(Output: HtmlTextWriter); override;
  public
    constructor Create;
  published
    [Bindable(true),
     Category('Appearance'),
     DefaultValue('')]
    property Text: string read FText write FText;

  {$REGION 'DB Web control declarations'}
  // Implement code from this region for controls that use the DB Web interfaces
  {$REGION 'IDBWebDataLink declarations'}
  {$IFDEF DBWEB}
  strict protected
    procedure OnInit(e: EventArgs); override;
    procedure OnPreRender(args: EventArgs); override;
    // For more information on IPostBackDataHandler, see the help entry
    // ms-help://borland.bds2/cpref/html/frlrfSystemWebUIIPostBackDataHandlerClassLoadPostDataTopic.htm
    function LoadPostData(postDataKey: string;
      postCollection: NameValueCollection) : boolean;
    procedure RaisePostDataChangedEvent;

  // IDBWebDataLink is the core interface for the DB Web controls
  // and must be implemented for all DB Web controls

  private // Should this be strict private?
    FDataLink: DBWebDataLink;
    FIDataLink: IDBWebDataLink;
    function GetTableName: string;
    procedure SetTableName(Value: string);
    function GetDataSource: IDBDataSource;
    procedure SetDataSource(Value: IDBDataSource);

  public
    property IDataLink: IDBWebDataLink read FIDataLink;
    procedure DataBind; override;

  published
    [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property TableName: string read GetTableName write SetTableName;
		[LocalizableCategoryAttribute('DBWebControl'),
  		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
  		DefaultValue('')]
    property DBDataSource: IDBDataSource read GetDataSource write SetDataSource;

  {$ENDIF}
  {$ENDREGION}
  {$REGION 'IDBWebColumnLink declarations'}
  // IDBWebColumnLink is used to databind to a specific column (optional)
  {$IFDEF DBWEBCOLUMN}
  private // Should this be strict private?
    FIColumnLink: IDBWebColumnLink;
    function GetIColumnLink : IDBWebColumnLink;
    function GetColumnName: string;
    procedure SetColumnName(Value: string);

  public
    property IColumnLink: IDBWebColumnLink read GetIColumnLink;

  published
    [Editor(typeof(Borland.Data.Web.ColumnNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property ColumnName: string read GetColumnName write SetColumnName;
  {$ENDIF}
  {$ENDREGION}

  {$REGION 'IDBWebLookupColumnLink declarations'}
  // IDBWebLookupColumnLink descends from IDBWEbColumnLink, and supports
  // properties for lookup table values
  {$IFDEF DBWEBLOOKUP}
  private // Should this be strict private?
    FILookupLink: IDBWebLookupColumnLink;
    function GetILookupLink : IDBWebLookupColumnLink;
    function GetLookupTableName: string;
    procedure SetLookupTableName(Value: string);
    function GetDataTextField: string;
    procedure SetDataTextField(Value: string);
    function GetDataValueField: string;
    procedure SetDataValueField(Value: string);

  public
    property ILookupLink: IDBWebLookupColumnLink read GetILookupLink;

  published
    [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property LookupTableName : string read GetLookupTableName
      write SetLookupTableName;
    [Editor(typeof(Borland.Data.Web.LookupColumnNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property DataTextField : string read GetDataTextField
      write SetDataTextField;
    [Editor(typeof(Borland.Data.Web.LookupColumnNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property DataValueField : string read GetDataValueField
      write SetDataValueField;
  {$ENDIF}
  {$ENDREGION}

  {$ENDREGION}
  end;

implementation

{$IFNDEF DBWEB}
/// <summary>
/// Define a public parameterless constructor needed by web controls.
/// This is the default constructor.
/// </summary>
constructor My[!CustomControlName].Create;
begin
  inherited;
end;
{$ENDIF}

{$REGION 'Control.Render override'}
(*
/// <summary>
/// Render this control to the output parameter specified.
/// The override for Render should be used when descending directly from
/// System.Web.UI.WebControls.Control, or when creating a composite control
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure My[!CustomControlName].Render(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
(**)
{$ENDREGION}

{$REGION 'WebControl.RenderContents override'}
/// <summary>
/// Render this control to the output parameter specified.
/// The override for RenderContents should be used when descending from
/// System.Web.UI.WebControls.WebControl so all cosmetic attributed
/// are rendered appropriately for the control
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure My[!CustomControlName].RenderContents(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
{$ENDREGION}

{$REGION 'DB Web control implementation'}
// For all DB web control implementations, the IDBWebDataLink implementation
// region is required. Furthermore, the IDBWebColumnLink region is required
// for components that implement the IDBWebLookupColumnLink.
{$REGION 'IDBWebDataLink implementation'}
{$IFDEF DBWEB}
/// <summary>
// Construct the required private instance variables, depending on the
// defined options for this control.
/// Use this procedure if IDBWebDataLink interface is implemented
/// </summary>
constructor My[!CustomControlName].Create;
begin
  inherited;

  // Conditional initializers
  {$IF Defined(DBWEBLOOKUP)}
  // Initialize with most complex interface, IDBWebLookupColumnLink
  FDataLink := DBWebLookupColumnLink.Create(self);
  FILookupLink := (FDatalink as IDBWebLookupColumnLink);
  FIColumnLink := (FDataLink as IDBWebColumnLink);
  {$ELSEIF Defined(DBWEBCOLUMN)}
  // For IDBWebColumnLink, use this initializer instead
  FDataLink := DBWebColumnLink.Create(self);
  FIColumnLink := (FDataLink as IDBWebColumnLink);
  {$ELSE}
  // Initialize FDatalink for IDBWebDataLink implementation
  FDataLink := DBWebDataLink.Create(self);
  {$IFEND}

  // Standard DB Web interface should always be defined
  FIDataLink := (FDataLink as IDBWebDataLink);
end;

/// <summary>
/// Override the default initialization method to require postback
/// </summary>
procedure My[!CustomControlName].OnInit(e: EventArgs);
begin
  inherited OnInit(e);
  if Assigned(Page) then
    Page.RegisterRequiresPostBack(self);
end;

/// <summary>
/// Enhance the OnPreRender event for IDBWebDataLink
/// </summary>
procedure My[!CustomControlName].OnPreRender(args: EventArgs);
begin
  inherited OnPreRender(args);
  // You need to register the hidden field to identify the key for
  // read-write controls only. Remove this call if control is read-only.
  Page.RegisterHiddenField(DBWebDataSource.IdentPrefix + DBWebConst.Splitter
    + IDataLink.TableName, self.ID);
  DataBind;
end;

// RaisePostDataChangedEvent is called prior to DataBind()
// DataSet and related properties are NOT available here
// Child controls are not available
function My[!CustomControlName].LoadPostData(postDataKey:string;
  postCollection: NameValueCollection) : boolean;
begin
  FDataLink.LoadPostData(postDataKey, postCollection);
  Result := false;
end;

procedure My[!CustomControlName].RaisePostDataChangedEvent;
begin
  // Put custom data change handling code here
end;

// IDBWebDataLink setters/getters
function My[!CustomControlName].GetTableName: string;
begin
  Result := FIDataLink.TableName;
end;

procedure My[!CustomControlName].SetTableName(Value: string);
begin
  FIDataLink.TableName := Value;
end;

function My[!CustomControlName].GetDataSource: IDBDataSource;
begin
  Result := FIDataLink.DBDataSource;
end;

procedure My[!CustomControlName].SetDataSource(Value: IDBDataSource);
begin
  FIDataLink.DBDataSource := Value;
end;

procedure My[!CustomControlName].DataBind;
{$IFDEF DBWEBCOLUMN}
var
  obj: System.Object;
{$ENDIF}
begin
  try
    // Text is the default property that is getting data bound here.
    // DataBind whatever properties you require wherever you see
    // Text being databound.
    // See the C# source code for DBWebNavigator and DBWebLabeledTextBox
    // for additional examples.

    // Set value to blank if not data bound
    if (not FDataLink.IsDataBound) then
      Text := nil;

    // call to inherited triggers setting of DBDataSource.
		inherited DataBind;
    {$IFDEF DBWEBCOLUMN}
    if FDataLink.IsDataBound then
    begin
      obj := FIColumnLink.DBDataSource.GetColumnValue(Page,
        FIColumnLink.TableName, FIColumnLink.ColumnName);
      if Assigned(obj) then
      begin
				Text := obj.ToString();
			  inherited DataBind;
      end
      else
        Text := nil;
    end;
    {$ENDIF}
  except
  on E: Exception do
	begin
    if (not ClassUtils.IsDesignTime(Page)) then
				Page.Response.Write(ClassUtils.GetInternalError(Page, FIDataLink, E,
        Self.ID))
    else
		  Raise Exception(E);
  end;
end;

end;
{$ENDIF}
{$ENDREGION}

{$REGION 'IDBWebColumnLink implementation'}
{$IFDEF DBWEBCOLUMN}
function My[!CustomControlName].GetIColumnLink : IDBWebColumnLink;
begin
  Result := FIColumnLink; // Could be weak referenced instead
end;

function My[!CustomControlName].GetColumnName: string;
begin
  Result := IColumnLink.ColumnName;
end;

procedure My[!CustomControlName].SetColumnName(Value: string);
begin
  IColumnLink.ColumnName := Value;
end;
{$ENDIF}

{$ENDREGION}

{$REGION 'IDBWebLookupColumnLink implementation'}
{$IFDEF DBWEBLOOKUP}
function My[!CustomControlName].GetILookupLink : IDBWebLookupColumnLink;
begin
  Result := FILookupLink; // Could be weak referenced instead
end;

function My[!CustomControlName].GetLookupTableName: string;
begin
  Result := ILookupLink.LookupTableName;
end;

procedure My[!CustomControlName].SetLookupTableName(Value: string);
begin
  ILookupLink.LookupTableName := Value;
end;

function My[!CustomControlName].GetDataTextField: string;
begin
  Result := ILookupLink.DataTextField;
end;

procedure My[!CustomControlName].SetDataTextField(Value: string);
begin
  ILookupLink.DataTextField := Value;
end;

function My[!CustomControlName].GetDataValueField: string;
begin
  Result := ILookupLink.DataValueField;
end;

procedure My[!CustomControlName].SetDataValueField(Value: string);
begin
  ILookupLink.DataValueField := Value;
end;
{$ENDIF}
{$ENDREGION}

{$ENDREGION}

end.
